<form role="form" class="d-inline" id="cancel-moves">
    <button type="submit" class="btn btn-sm btn-outline-danger save"><?php echo app('translator')->get('Cancelar'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Cancelado'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Cancelando'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: cancelMoves
    });

    $('#cancel-moves').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});


function cancelMoves() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#cancel-moves').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.stock.move.cancel')); ?>",
        data: data,
        beforeSend: function () {
            $('form#cancel-moves button.save').addClass('d-none');
            $('form#cancel-moves button.saved').addClass('d-none');
            $('form#cancel-moves button.error').addClass('d-none');
            $('form#cancel-moves button.saving').removeClass('d-none');
        },
        statusCode: {
            204: function (response) {
                loadItems();
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entradas canceladas"); ?>.'
                });

                $('form#cancel-moves button.save').addClass('d-none');
                $('form#cancel-moves button.saved').removeClass('d-none');
                $('form#cancel-moves button.saving').addClass('d-none');
                $('form#cancel-moves button.error').addClass('d-none');


            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
        },
        error: (response) => {
            $('form#cancel-moves button.save').addClass('d-none');
            $('form#cancel-moves button.saved').addClass('d-none');
            $('form#cancel-moves button.saving').addClass('d-none');
            $('form#cancel-moves button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#cancel-moves button.save').removeClass('d-none');
                $('form#cancel-moves button.saved').addClass('d-none');
                $('form#cancel-moves button.saving').addClass('d-none');
                $('form#cancel-moves button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/create/parts/mini/cancel-btn.blade.php ENDPATH**/ ?>