<div>

    
    <form wire:submit.prevent='modal' id="invoiceBydelivery" class="card card-primary card-outline card-outline-tabs p-5">

        <div class="row">

            <div class="form-group col-sm-4" wire:ignore>
                <label for="cliente"><?php echo app('translator')->get('Cliente'); ?></label>
                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                    data-live-search="true" name="cliente" wire:model="customers_id" required
                    wire:change='onChangeCustomers' id="dataPicker1" title="Buscar Cliente">

                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($customer->id); ?>"  data-tokens="<?php echo e($customer->code); ?>" wire:key='<?php echo e($customer->id); ?>'
                        <?php if($customer->invoices->isNotEmpty()): ?>
                            hasBills=1
                        <?php endif; ?>
                        >
                        <?php echo e($customer->name); ?> </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <div wire:loading wire:target="onChangeCustomers">
                    <div class="spinner-border text-warning" role="status">
                        <span class="sr-only">Loading...</span>
                      </div>
                </div>
            </div>

            <div class="form-group col-sm-4" wire:ignore>
                <label for="cliente"><?php echo app('translator')->get('Guias de Remessas'); ?></label>
                <select wire:model='delivers_id' class="selectpicker  form-control remove-example"
                        data-style="btn-outline-primary" data-size="1"
                        data-live-search="true" name="guias" multiple
                        required title="Digite o codigo da guia aqui" id="dataPicker2" autocomplete="off">
                        <option></option>
                    <?php $__currentLoopData = $delivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <option value="<?php echo e($delivery->id); ?>" wire:key='<?php echo e($delivery->id); ?>'><?php echo e($delivery->name()); ?></option>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group col-sm-4">
                <label for="cliente" style="color: red"><?php echo app('translator')->get('Guias não faturadas'); ?></label>
                <select class="form-control" data-style="btn-outline-primary"  name="guias" aria-readonly="true"  multiple>
                    <?php $__currentLoopData = $customerDelivery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <option aria-readonly="true"><?php echo e($delivery); ?></option>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>



            <div class="form-group col-sm-12">
                <label for="obs"><?php echo app('translator')->get('Observação'); ?></label>
                <textarea wire:model='obs' class="form-control" rows="2" name="obs" placeholder="Observação..."></textarea>
            </div>

        </div>


        <div class="row">
            <div class="col-12">
                <button  type="submit"  class="btn bg-gradient-cyan"><?php echo app('translator')->get('Emitir a factura'); ?></button>
                <div wire:loading wire:target="modal">
                    <div class="spinner-border text-warning" role="status">
                        <span class="sr-only">Loading...</span>
                      </div>
                </div>
            </div>
        </div>
    </form>



  <?php if($show): ?>
  <div class="card card-primary card-outline card-outline-tabs p-5">

    <h5 class="modal-title mb-2" id="exampleModalLabel">
        <button wire:click='finalizar'   type="button" class="btn btn-outline-success" data-dismiss="modal"><?php echo app('translator')->get('Finalizar'); ?></button>
        <button wire:click='finalizar_imprimir' type="submit" class="btn btn-outline-info" data-dismiss="modal" ><?php echo app('translator')->get('Finalizar e Imprimir'); ?></button>
        &nbsp;
        <div wire:loading wire:target="finalizar_imprimir">
            <div class="spinner-border text-warning" role="status">
                <span class="sr-only">Loading...</span>
              </div>
        </div>
        <div wire:loading wire:target="finalizar">
            <div class="spinner-border text-warning" role="status">
                <span class="sr-only">Loading...</span>
              </div>
        </div>
      <div wire:loading wire:target="editar">
          <div class="spinner-border text-success" role="status">
              <span class="sr-only">Loading...</span>
            </div>
      </div>
      <button wire:click='fechar'    type="button" class="btn btn-outline-warning float-right" data-dismiss="modal"><?php echo app('translator')->get('Cancelar'); ?></button>
    </h5>




    <dl class="row">

        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('Documento'); ?></dt>
            <dd>Factura Baseada Em Guia</dd>
        </div>

        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('Prazo de pagamento'); ?></dt>
            <dd><?php echo app('translator')->get('Não especificado '); ?></dd>
        </div>



        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('Valor total'); ?></dt>
            <dd><?php echo e(number_format($total, 2)); ?></dd>
        </div>
        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('Guias de Remessas'); ?></dt>
            <?php $__currentLoopData = $deliveryName; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deli): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <dd><?php echo e($deli); ?></dd>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('Cliente'); ?></dt>

            <dd><?php echo e($customerName); ?></dd>

        </div>

        <div class="col-sm-6 col-md-4">
            <dt><?php echo app('translator')->get('NUIT'); ?></dt>
            <dd><?php echo e($customerNuit); ?></dd>
        </div>


    </dl>
    <div class="row">
        <div class="col-12 table-responsive">
            <table class="table table-sm table-body table-bordered my-1 mt-3">
                <thead class="">
                    <tr>
                        <th class="text-left;"><?php echo app('translator')->get('Codigo'); ?></th>
                        <th class="text-left;"><?php echo app('translator')->get('Artigo'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Preço'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Qty'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Desconto'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('IVA'); ?> %</th>
                        <th class="text-center"><?php echo app('translator')->get('Subtotal'); ?></th>
                    </tr>
                </thead>
                <tbody>
                            <?php $__currentLoopData = $deliveryNotesItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(is_object($item)): ?>
                                    <tr>
                                        <td class="text-left"><?php echo e($item->sale_code); ?></td>
                                        <td class="text-left"><?php echo e($item->sale_name); ?></td>
                                        <td class="text-right"><?php echo e(number_format($item->unit_amount,  2)); ?></td>
                                        <td class="text-right"><?php echo e(number_format($item->quantity)); ?></td>
                                        <td class="text-right"><?php echo e(number_format($item->discount, 2)); ?></td>
                                        <td class="text-right"><?php echo e(number_format($item->vat_tax, 2)); ?></td>
                                        <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
  <?php endif; ?>





    <script type="text/javascript">

        document.addEventListener('livewire:update', function () {



                if (window.livewire.find('<?php echo e($_instance->id); ?>').show) {



                        $("#dataPicker1").val('default');
                        $("#dataPicker1").selectpicker("refresh");

                        $("#dataPicker2").val('default');
                        $("#dataPicker2").selectpicker("refresh");

                        $('.selectpiker').selectpicker('deselectAll');

                        // $("#myModal").modal();
                }


                if (window.livewire.find('<?php echo e($_instance->id); ?>').is_customer_changed) {


                            console.log(window.livewire.find('<?php echo e($_instance->id); ?>').deliveryNotesItems);

                            let array = window.livewire.find('<?php echo e($_instance->id); ?>').customerDelivery;

                            array.forEach(element => {
                                console.log(element);

                            });

                    }


        });



    </script>




</div>


<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/livewire/invoice-by-delivery-note/invoice-by-delivery-note.blade.php ENDPATH**/ ?>