<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <?php echo app('translator')->get('Finalizar'); ?>
        </h3>
    </div>
    <div class="card-body">
        <?php echo $__env->make('sales.returns.create.common.finalize-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="table" class="mt-2"></div>
    </div>
</div>

<?php $__env->startSection('plugins.Handlebars', true); ?>
<script id="table-template" type="text/x-handlebars-template">
    <table  class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Código'); ?></th>
                    <th><?php echo app('translator')->get('Produto'); ?></th>
                    <th><?php echo app('translator')->get('Quantidade'); ?></th>
                    <th><?php echo app('translator')->get('Preço Unitário'); ?></th>
                    <th><?php echo app('translator')->get('Desconto'); ?></th>
                    <th><?php echo app('translator')->get('Preço total'); ?></th>
                    <th><?php echo app('translator')->get('Apagar'); ?></th>
                </tr>
            </thead>
            <tbody>
            {{#each items }}
                <tr>
                    <td>{{ this.code }}</td>
                    <td>{{ this.name }}</td>
                    <td>{{ this.quantity }}</td>
                    <td>{{ this.unit_amount }}</td>
                    <td>{{ this.discount }}</td>
                    <td>{{ this.total }}</td>
                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('{{ links.self }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            {{/each}}

            </tbody>
        </table>
</script>
<?php $__env->startPush('js'); ?>

<script type="text/javascript">
    $(document).ready(loadItems);

    var coast = 0;

    function loadItems(){
        $.ajax({
            ...ajaxSettings,
            type: "GET",
            url: "<?php echo e(URL::signedRoute('api.sales.returns.show', ['return' => $return->id])); ?>",
            dataType: "JSON",

            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },

            success: function (response) {
                coast = response.data.total_amount
                $('input[name="total"]').val(coast);
                handlebar.init(response.data.items);
            }
        });
    }
    function remove(url){
        $.ajax({
            ...ajaxSettings,
            type: "DELETE",
            url:url,
            dataType: "JSON",
            statusCode: {
                204: loadItems,
                401: (response) => {
                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
            },
        });
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/returns/create/common/handlebars.blade.php ENDPATH**/ ?>