<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
<?php $__env->stopSection(); ?>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <?php echo app('translator')->get('Turnos'); ?>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('ID'); ?></th>
                    <th><?php echo app('translator')->get('Usuário'); ?></th>
                    <th><?php echo app('translator')->get('Abertura'); ?></th>
                    <th><?php echo app('translator')->get('Fecho'); ?></th>
                    <th><?php echo app('translator')->get('Encerrado por'); ?></th>
                    <th><?php echo app('translator')->get('Duração'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.shift.show', ['shift'=>$shift->id])); ?>')"
                    class="cursor-pointer">
                    <td><?php echo e($shift->id); ?></td>
                    <td><?php echo e($shift->user->name); ?></td>
                    <td><?php echo e($shift->started_at->format('H:i d/m/Y')); ?></td>
                    <td><?php echo e($shift->isOpen()? __("Aberto") : $shift->ended_at->format('H:i d/m/Y')); ?></td>
                    <td><?php echo e($shift->isOpen()? '' : $shift->closedByUser->name); ?></td>
                    <td><?php echo e($shift->duration()); ?> Horas</td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><?php echo app('translator')->get('ID'); ?></th>
                    <th><?php echo app('translator')->get('Usuário'); ?></th>
                    <th><?php echo app('translator')->get('Abertura'); ?></th>
                    <th><?php echo app('translator')->get('Fecho'); ?></th>
                    <th><?php echo app('translator')->get('Encerrado por'); ?></th>
                    <th><?php echo app('translator')->get('Duração'); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/shifts/shift/list/parts/table.blade.php ENDPATH**/ ?>