<form role="form" class="" id="finalize-cashsale">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="gender"><?php echo app('translator')->get('Cliente'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"

                data-live-search="true" name="customer">

                <option>Escolha o cliente</option>

                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($customer->id); ?>" data-tokens="<?php echo e($customer->code); ?>">
                    <?php echo e($customer->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="customer_name"><?php echo app('translator')->get('Customer Name'); ?></label>
            <input type="text" name="customer_name" class="form-control" id="customer_name" placeholder="Enventual Company">
        </div>

        <div class="form-group col-sm-4">
            <label for="customer_vat"><?php echo app('translator')->get('Customer VAT'); ?></label>
            <input type="text" name="customer_vat" class="form-control" id="customer_vat" placeholder="123456789">
        </div>

        <div class="form-group col-sm-4">
            <label for="customer_address"><?php echo app('translator')->get('Customer Address'); ?></label>
            <input type="text" name="customer_address" class="form-control" id="customer_address" placeholder="Maputo">
        </div>

        <div class="form-group col-md-4">
            <label for="gender"><?php echo app('translator')->get('Metodo de pagamento'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="6"
                data-live-search="false" name="payment_method">
                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($payment->id); ?>" data-tokens="<?php echo e($payment->id); ?>">
                    <?php echo e($payment->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="discount"><?php echo app('translator')->get('Desconto'); ?></label>
            <input type="text" name="discount" class="form-control" id="discount" placeholder="1500" value="0">
        </div>

        <div class="form-group col-sm-6">
            <label for="bank_name"><?php echo app('translator')->get('Nome do Banco'); ?></label>
            <input type="text" name="bank_name" class="form-control" id="bank_name" placeholder="BCI" value="">
        </div>
        <div class="form-group col-sm-6">
            <label for="bank_document_nr"><?php echo app('translator')->get('Número do Documento'); ?></label>
            <input type="text" name="bank_document_nr" class="form-control" id="bank_document_nr" placeholder="BCI0001"
                value="">
        </div>

        <div class="form-group col-sm-12">
            <label for="bank_document_nr"><?php echo app('translator')->get('Observação'); ?></label>
            <textarea class="form-control" rows="2" name="obs" placeholder="Enter ..."></textarea>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="button" class="btn btn-sm btn-outline-primary save "><?php echo app('translator')->get('Finalizar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-info save-print"><?php echo app('translator')->get('Finalizar e
                Imprimir'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Finalizado'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Finalizando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>

</form>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-cashsale button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-cashsale button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});

function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });
    
    let data = $('form#finalize-cashsale').serializeArray();

    console.log(data);

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.sales.cashsale.update', ['cashsale'=> $cashsale->id])); ?>",
        data: data,
        beforeSend: function () {

            $('form#finalize-cashsale button.save').addClass('d-none');
            $('form#finalize-cashsale button.saved').addClass('d-none');
            $('form#finalize-cashsale button.error').addClass('d-none');
            $('form#finalize-cashsale button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entradas finalizadas"); ?>.'
                });

                $('form#finalize-cashsale button.save').addClass('d-none');
                $('form#finalize-cashsale button.saved').removeClass('d-none');
                $('form#finalize-cashsale button.saving').addClass('d-none');
                $('form#finalize-cashsale button.error').addClass('d-none');


                if (print)
                    goto('<?php echo e(URL::signedRoute('web.sales.cashsale.print.pdf', ['cashsale'=> $cashsale->id])); ?>')
                else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            }
        },
        error: (response) => {
            $('form#finalize-cashsale button.save').addClass('d-none');
            $('form#finalize-cashsale button.saved').addClass('d-none');
            $('form#finalize-cashsale button.saving').addClass('d-none');
            $('form#finalize-cashsale button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-cashsale button.save').removeClass('d-none');
                $('form#finalize-cashsale button.saved').addClass('d-none');
                $('form#finalize-cashsale button.saving').addClass('d-none');
                $('form#finalize-cashsale button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/cashsale/create/parts/mini/finalize-btn.blade.php ENDPATH**/ ?>