<form role="form" class="" id="delete-saleable">
    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-danger save"><?php echo app('translator')->get('Apagar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Apagado'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Apagando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: deleteSaleable
      });

      $('#delete-saleable').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    function deleteSaleable(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#delete-saleable').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'DELETE',
            url: "<?php echo e(URL::route('api.stock.saleable.destroy', ['saleable'=>$saleable->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#delete-saleable button.save').addClass('d-none');
              $('form#delete-saleable button.saved').addClass('d-none');
              $('form#delete-saleable button.error').addClass('d-none');
              $('form#delete-saleable button.saving').removeClass('d-none');
            },
            statusCode : {
                204: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Product has been edited"); ?>.'
                  })

                  $('form#delete-saleable button.save').addClass('d-none');
                  $('form#delete-saleable button.saved').removeClass('d-none');
                  $('form#delete-saleable button.saving').addClass('d-none');
                  $('form#delete-saleable button.error').addClass('d-none');
                    setTimeout(() => {
                        goto("<?php echo e(URL::route('web.stock.saleable.index')); ?>");
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::route('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#delete-saleable button.save').addClass('d-none');
              $('form#delete-saleable button.saved').addClass('d-none');
              $('form#delete-saleable button.saving').addClass('d-none');
              $('form#delete-saleable button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#delete-saleable button.save').removeClass('d-none');
                $('form#delete-saleable button.saved').addClass('d-none');
                $('form#delete-saleable button.saving').addClass('d-none');
                $('form#delete-saleable button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/saleable/show/parts/mini/delete.blade.php ENDPATH**/ ?>