<p align="center">
    <picture>
      <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/php-flasher/art/main/php-flasher-logo-dark.svg">
      <img  width="600" src="https://raw.githubusercontent.com/php-flasher/art/main/php-flasher-logo.svg" alt="PHPFlasher Logo">
    </picture>
</p>

<p align="center">Flexible flash notifications system for PHP</p>

Flash messages are a great way to add some simple notifications to users of your website or application about important events that may have happened.

PHPFlasher gives a straightforward way to give feedback messages in the current or the next page to users with a flashing system.

The flashing system basically makes it possible to record a message and store it within the session so that it can be retrieved when needed.


## Official Documentation

Documentation for PHPFlasher can be found on the [PHPFlasher website](https://php-flasher.io).

<p align="center">
    <a href="https://github.com/php-flasher/flasher">
        <img src="https://img.shields.io/badge/source-php--flasher/flasher-blue.svg?style=flat-square">
    </a>
    <a href="https://github.com/php-flasher/flasher/releases">
        <img src="https://img.shields.io/github/tag/php-flasher/flasher.svg">
    </a>
    <a href="https://github.com/php-flasher/flasher/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/license-MIT-brightgreen.svg">
    </a>
    <a href="https://packagist.org/packages/php-flasher/flasher">
        <img src="https://img.shields.io/packagist/dt/php-flasher/flasher.svg">
    </a>
    <a href="https://packagist.org/packages/php-flasher/flasher">
        <img src="https://img.shields.io/packagist/php-v/php-flasher/flasher.svg?style=flat-square">
    </a>
</p>

# Why use PHPFlasher ?

The PHPFlasher project supports many notification libraries : [__toastr.js__](https://php-flasher.io/docs/adapter/toastr/), [__sweetalert 2__](https://php-flasher.io/docs/adapter/sweetalert/), [__pnotify__](https://php-flasher.io/docs/adapter/pnotify/), [__noty__](https://php-flasher.io/docs/adapter/noty/) and [__notyf__](https://php-flasher.io/docs/adapter/notyf/)
and its highly extendable so you can add your custom notifications.

This library is designed, so you can take full control when creating you notifications :

> * Show various notifications simultaneously
> * Render notification easily from javascript with small footprint
> * LTR and Dark-mode support
> * Limit the amount of displayed notifications
> * Show Desktop notifications for Linux, macOS and Windows
> * Framework-agnostic with implementations for: Symfony and Laravel
> * Autocomplete for PHPSTORM
> *  You can always create an adapter yourself
> * ...and more


## Official Documentation

Documentation for PHPFlasher can be found on the [PHPFlasher website](https://php-flasher.io).

### Contact

PHPFlasher is being actively developed by <a href="https://github.com/yoeunes">yoeunes</a>. You can reach out with questions, bug reports, or feature requests 
on any of the following:

- [Github Issues](https://github.com/php-flasher/flasher/issues) 
- [Github](https://github.com/yoeunes)
- [Twitter](https://twitter.com/yoeunes)
- [Linkedin](https://www.linkedin.com/in/younes-khoubza/)
- [Email me directly](mailto:younes.khoubza@gmail.com)

## License

PHPFlasher is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).

<p align="center"> <b>Made with ❤️ by <a href="https://www.linkedin.com/in/younes-khoubza/">Younes KHOUBZA</a> <b> </p>
